package ru.yandex.msearch.proxy.api.async.mail.direct;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;
import ru.yandex.search.result.SearchDocument;
import ru.yandex.search.result.SearchResult;

public class LuceneDocuments implements Documents {
    private int hitsCount;

    private List<LuceneDocument> documents;

    public LuceneDocuments(final SearchResult result) {
        this.hitsCount = (int) result.hitsCount();
        this.documents = new ArrayList<>(hitsCount);
        this.add(result);
    }

    @Override
    public void add(
        final String groupId,
        final Document doc)
    {
        this.add(doc.doc());
    }

    public void add(final SearchDocument doc) {
        this.documents.add(new LuceneDocument(doc));
    }

    public void add(final SearchResult result) {
        result.hitsArray().forEach(this::add);
    }

    @Override
    public int size() {
        return documents.size();
    }

    @Override
    public void total(final long total) {
    }

    @Override
    public long total() {
        return hitsCount;
    }

    @Override
    public void clear() {
        this.documents.clear();
    }

    @Override
    public List<? extends DocumentsGroup> sort() {
        return documents;
    }

    @Override
    public Comparator<Document> comparator() {
        return null;
    }

    @Override
    public Iterator<DocumentsGroup> iterator() {
        return new ArrayList<DocumentsGroup>(documents).iterator();
    }

    @Override
    public long relevant() {
        return 0;
    }
}
