package ru.yandex.msearch.proxy.api.async.mail.direct;

import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.rules.AbstractPlainSearchCallback;
import ru.yandex.msearch.proxy.api.async.mail.rules.RuleContext;
import ru.yandex.msearch.proxy.api.async.mail.searcher.PlainSearcher;
import ru.yandex.msearch.proxy.api.async.mail.searcher.ProducerParallelSearcher;
import ru.yandex.search.result.SearchResult;
import ru.yandex.stater.RequestInfo;
import ru.yandex.util.timesource.TimeSource;

public class SimplePlainSearchCallback extends AbstractPlainSearchCallback {
    protected final PlainSearcher searcher;

    public SimplePlainSearchCallback(
        final SearchSession session,
        final RuleContext context,
        final SearchRequest request)
        throws BadRequestException
    {
        super(session, context, request);

        searcher = new ProducerParallelSearcher(
            session.httpSession(),
            session.params(),
            request.user());
    }

    @Override
    protected PlainSearcher searcher() {
        return searcher;
    }

    @Override
    protected Function<? super HttpHost, ? extends HttpAsyncRequestProducer> nextRequest() {
        StringBuilder sb = new StringBuilder(request.luceneRequest());
        sb.append("&length=");
        sb.append(session.requestInfo().length());
        sb.append("&offset=");
        sb.append(session.requestInfo().offset());
        return new BasicAsyncRequestProducerGenerator(sb.toString());
    }

    @Override
    public void completed(final SearchResult result) {
        done = true;
        stater.accept(
            new RequestInfo(
                TimeSource.INSTANCE.currentTimeMillis(),
                HttpStatus.SC_OK,
                start,
                start,
                0L,
                result.hitsArray().size()));

        this.session.callback().completed(new LuceneDocuments(result));
    }
}
