package ru.yandex.msearch.proxy.api.async.mail.direct;

import org.apache.http.HttpException;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.SingleFieldSortOrder;

import ru.yandex.msearch.proxy.api.async.mail.rules.AbstractPlainSearchCallback;
import ru.yandex.msearch.proxy.api.async.mail.rules.AbstractPlainSearchRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.RuleContext;

public class SimplePlainSearchRule extends AbstractPlainSearchRule {
    public SimplePlainSearchRule(final RuleContext context) {
        super(context);
    }

    @Override
    protected AbstractPlainSearchCallback createCallback(
        final SearchSession session,
        final SearchRequest request)
        throws BadRequestException
    {
        return
            new SimplePlainSearchCallback(
                session,
                context,
                request);
    }

    @Override
    protected SearchRequest request(
        final SearchSession session)
        throws HttpException
    {
        return new SearchRequest(
            session.params().getEnum(
                SingleFieldSortOrder.class,
                "order",
                SingleFieldSortOrder.DEFAULT),
            session,
            context);
    }
}
