package ru.yandex.msearch.proxy.api.async.mail.documents;

import ru.yandex.json.dom.JsonMap;

import ru.yandex.search.result.SearchDocument;

public class BasicDocument implements Document {
    private final String id;
    private final SearchDocument doc;
    private final JsonMap envelope;

    public BasicDocument(
        final String id,
        final SearchDocument doc,
        final JsonMap envelope)
    {
        this.id = id;
        this.doc = doc;
        this.envelope = envelope;
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public SearchDocument doc() {
        return doc;
    }

    @Override
    public JsonMap envelope() {
        return envelope;
    }

    @Override
    public int hashCode() {
        return id.hashCode() ^ doc.hashCode() ^ envelope.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof Document) {
            Document other = (Document) o;
            return id.equals(other.id())
                && doc.equals(other.doc())
                && envelope.equals(other.envelope());
        }
        return false;
    }
}

