package ru.yandex.msearch.proxy.api.async.mail.documents;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BasicDocuments implements Documents {
    protected final Comparator<Document> comparator;
    protected final Map<String, DocumentsGroup> groups;
    protected long total;

    public BasicDocuments(final Comparator<Document> comparator) {
        this(comparator, new HashMap<String, DocumentsGroup>());
    }

    public BasicDocuments(
        final Comparator<Document> comparator,
        final int size)
    {
        this(comparator, new HashMap<String, DocumentsGroup>(size));
    }

    protected BasicDocuments(
        final Comparator<Document> comparator,
        final Map<String, DocumentsGroup> groups)
    {
        this.comparator = comparator;
        this.groups = groups;
    }

    protected DocumentsGroup createDocumentsGroup(
        final String groupId,
        final Document doc)
    {
        return new BasicDocumentsGroup(groupId, comparator, doc);
    }

    @Override
    public void add(final String groupId, final Document doc) {
        DocumentsGroup group = groups.get(groupId);
        if (group == null) {
            groups.put(groupId, createDocumentsGroup(groupId, doc));
        } else {
            group.add(doc);
        }
    }

    @Override
    public Iterator<DocumentsGroup> iterator() {
        return groups.values().iterator();
    }

    @Override
    public int size() {
        return groups.size();
    }

    @Override
    public void clear() {
        total = 0;
        groups.clear();
    }

    @Override
    public List<DocumentsGroup> sort() {
        List<DocumentsGroup> groups = new ArrayList<>(this.groups.values());
        Collections.sort(groups, new DocumentsGroupComparator(comparator));
        return groups;
    }

    @Override
    public Comparator<Document> comparator() {
        return comparator;
    }

    @Override
    public int hashCode() {
        return comparator.hashCode() ^ groups.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof Documents) {
            Documents other = (Documents) o;
            return size() == other.size()
                && comparator.equals(other.comparator())
                && sort().equals(other.sort());
        }
        return false;
    }

    @Override
    public long relevant() {
        return 0;
    }

    @Override
    public void total(final long total) {
        this.total = total;
    }

    @Override
    public long total() {
        return total;
    }
}

