package ru.yandex.msearch.proxy.api.async.mail.documents;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

import ru.yandex.collection.Iterators;

public class BasicDocumentsGroup implements DocumentsGroup {
    private final String id;
    private final Set<Document> docs;

    public BasicDocumentsGroup(
        final String id,
        final Comparator<Document> comparator,
        final Document doc)
    {
        this.id = id;
        docs = new TreeSet<>(comparator);
        docs.add(doc);
    }

    @Override
    public String id() {
        return id;
    }

    @Override
    public Iterator<Document> iterator() {
        return docs.iterator();
    }

    @Override
    public void add(final Document doc) {
        docs.add(doc);
    }

    @Override
    public Document best() {
        return iterator().next();
    }

    @Override
    public int size() {
        return docs.size();
    }

    @Override
    public int hashCode() {
        return id.hashCode() ^ docs.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        if (o instanceof DocumentsGroup) {
            DocumentsGroup other = (DocumentsGroup) o;
            return size() == other.size()
                && id.equals(other.id())
                && Iterators.equals(iterator(), other.iterator());
        }
        return false;
    }
}

