package ru.yandex.msearch.proxy.api.async.mail.documents;

import java.util.Comparator;
import java.util.List;

public interface Documents extends Iterable<DocumentsGroup> {
    // If there is no such group id, then new one will be created
    void add(String groupId, Document doc);
    int size();
    void clear();
    // Returns sorted view of documents groups
    List<? extends DocumentsGroup> sort();
    // Returns most relevant documents if present
    long relevant();
    // total available docs, may be greater than size
    void total(final long total);
    long total();

    Comparator<Document> comparator();
}

