package ru.yandex.msearch.proxy.api.async.mail.documents;

import java.util.Comparator;

public class DocumentsGroupComparator implements Comparator<DocumentsGroup> {
    private final Comparator<Document> comparator;

    public DocumentsGroupComparator(final Comparator<Document> comparator) {
        this.comparator = comparator;
    }

    @Override
    public int compare(final DocumentsGroup lhs, final DocumentsGroup rhs) {
        int cmp = comparator.compare(lhs.best(), rhs.best());
        if (cmp == 0) {
            cmp = lhs.id().compareTo(rhs.id());
        }
        return cmp;
    }

    @Override
    public int hashCode() {
        return comparator.hashCode();
    }

    @Override
    public boolean equals(final Object o) {
        return o instanceof DocumentsGroupComparator
            && comparator.equals(((DocumentsGroupComparator) o).comparator);
    }
}

