package ru.yandex.msearch.proxy.api.async.mail.folders;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class BasicUserFolders implements UserFolders {
    private final Map<String, Set<String>> userToFolders = new HashMap<>();
    private final Map<String, String> folderToUser = new HashMap<>();

    @Override
    public Set<String> users() {
        return userToFolders.keySet();
    }

    @Override
    public Set<String> userFolders(final String user) {
        Set<String> folders = userToFolders.get(user);
        if (folders == null) {
            folders = Collections.emptySet();
        }
        return folders;
    }

    @Override
    public String folderUser(final String folder) {
        return folderToUser.get(folder);
    }

    public void addUserFolder(final String user, final String folder) {
        folderToUser.put(folder, user);
        Set<String> folders = userToFolders.get(user);
        if (folders == null) {
            folders = new HashSet<>();
            userToFolders.put(user, folders);
        }
        folders.add(folder);
    }
}

