package ru.yandex.msearch.proxy.api.async.mail.folders;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.JsonAsyncConsumer;

import ru.yandex.json.parser.StringCollectorsFactory;

public class UserFoldersConsumer extends JsonAsyncConsumer<UserFolders> {
    private final UserFolders userFolders;

    public UserFoldersConsumer(final HttpEntity entity) throws HttpException {
        this(entity, new BasicUserFolders());
    }

    private UserFoldersConsumer(
        final HttpEntity entity,
        final BasicUserFolders userFolders)
        throws HttpException
    {
        super(
            entity,
            new UserFoldersJsonHandler(userFolders),
            StringCollectorsFactory.INSTANCE);
        this.userFolders = userFolders;
    }

    @Override
    protected UserFolders doBuildResult(final HttpContext context) {
        return userFolders;
    }
}

