package ru.yandex.msearch.proxy.api.async.mail.folders;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public class UserFoldersConsumerFactory
    implements HttpAsyncResponseConsumerFactory<UserFolders>
{
    public static final UserFoldersConsumerFactory INSTANCE =
        new UserFoldersConsumerFactory();
    public static final StatusCheckAsyncResponseConsumerFactory<UserFolders>
    OK = new StatusCheckAsyncResponseConsumerFactory<>(
        HttpStatusPredicates.OK,
        INSTANCE);

    protected UserFoldersConsumerFactory() {
    }

    @Override
    public UserFoldersConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new UserFoldersConsumer(response.getEntity());
    }
}

