package ru.yandex.msearch.proxy.api.async.mail.folders;

import java.util.List;

import ru.yandex.dbfields.OracleFields;

import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;

public class UserFoldersJsonHandler implements PrimitiveHandler {
    private final BasicUserFolders userFolders;
    private int prevIndex = -1;
    private String suid = null;
    private String fid = null;

    public UserFoldersJsonHandler(final BasicUserFolders userFolders) {
        this.userFolders = userFolders;
    }

    @Override
    public void handle(final List<PathComponent> path, final Object value) {
        if (path.size() == 2
            && path.get(0).name() == null
            && value != null)
        {
            int index = path.get(0).index();
            if (index != prevIndex) {
                suid = null;
                fid = null;
                prevIndex = index;
            }
            String key = path.get(1).name();
            if (OracleFields.UNAME.equals(key)) {
                suid = value.toString();
            } else if (OracleFields.FID.equals(key)) {
                fid = value.toString();
            }
            if (suid != null && fid != null) {
                userFolders.addUserFolder(suid, fid);
                suid = null;
                fid = null;
            }
        }
    }
}

