package ru.yandex.msearch.proxy.api.async.mail.furita;

import org.apache.http.HttpException;
import ru.yandex.msearch.proxy.api.async.ProxyParams;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.rules.LuceneQueryConstructor;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.util.string.StringUtils;

public class FuritaRewriteRequestRule implements SearchRule {
    private static final String SUBSCRIPTION_EMAIL =
        "subscription-email:";

    private final SearchRule next;

    public FuritaRewriteRequestRule(final SearchRule next) {
        this.next = next;
    }

    private String templatizeEmails(final String request) {
        StringBuilder sb = new StringBuilder(request.length() + 1);
        String[] emails = request.split(" ");
        int i = 0;
        for (String email: emails) {
            if (i > 0) {
                sb.append(' ');
            }
            if (email.indexOf('@') == -1) {
                sb.append(email);
            } else {
                sb.append(LuceneQueryConstructor.templatizeEmail(email));
            }
            i++;
        }
        return new String(sb);
    }

    private String templatizeRequest(final String rawRequest) {
        String request = rawRequest;

        while (true) {
            int sePos = request.indexOf(SUBSCRIPTION_EMAIL);
            if (sePos != -1) {
                int textStart = sePos + SUBSCRIPTION_EMAIL.length();
                int textEnd = request.length();
                int epilogStart = textStart;
                final String text;
                if (request.length() > textStart) {
                    if (request.charAt(textStart) == '(') {
                        textStart++;
                        textEnd = request.indexOf(')', textStart);
                        epilogStart = textEnd + 1;
                    } else if (request.charAt(textStart) == '"') {
                        textStart++;
                        textEnd = request.indexOf('"', textStart);
                        epilogStart = textEnd + 1;
                    } else {
                        textEnd = request.indexOf(' ', textStart);
                        epilogStart = textEnd;
                    }
                    if (textEnd == -1) {
                        textEnd = request.length();
                        epilogStart = textEnd;
                    }
                }
                text = request.substring(textStart, textEnd);
                String emails = templatizeEmails(text);
                String prolog = request.substring(0, sePos);
                String epilog = request.substring(epilogStart);
                request =
                    prolog + "hdr_from_normalized:(" + emails + ')' + epilog;
            } else {
                break;
            }
        }
        String prefixedRequest = StringUtils.concat(' ', request);
        if (prefixedRequest.contains(" type:")) {
            request =
                prefixedRequest.replaceAll(
                    "\\s+type:([^\"\'() \\t]+)",
                    " message_type:$1").trim();
        }

        return request;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        CgiParams params = session.params();

        boolean excludeTrash = params.getBoolean("exclude-trash", false);
        boolean excludeSpam = params.getBoolean("exclude-spam", false);
        //https://st.yandex-team.ru/MAILDLV-5534
        boolean excludeHiddenTrash
            = params.getBoolean("exclude-hidden-trash", true);
        int fid = params.getInt("fid", -1);

        boolean extra = excludeSpam || excludeTrash || fid > 0;

        String requestStr = params.getString("request");
        requestStr = templatizeRequest(requestStr);

        if (extra) {
            StringBuilder sb;
            if (!requestStr.isEmpty()) {
                sb = new StringBuilder();
                sb.append('(');
                sb.append(requestStr);
                sb.append(")");
            } else {
                sb = new StringBuilder("uid_p: ");
                sb.append(params.getLong(ProxyParams.UID));
            }

            if (excludeTrash) {
                sb.append(" AND NOT folder_type:trash");
            }

            if (excludeSpam) {
                sb.append(" AND NOT folder_type:spam");
            }

            if (excludeHiddenTrash) {
                sb.append(" AND NOT folder_type:hidden_trash");
            }

            if (fid >= 0) {
                sb.append(" AND fid:");
                sb.append(fid);
            }

            params.replace("request", sb.toString());
        } else {
            params.replace("request", requestStr);
        }

        params.replace("lowercase-expanded-terms", "1");
        params.replace("replace-ee-expanded-terms", "1");

        next.execute(session);
    }
}
