package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import org.apache.http.HttpException;

import ru.yandex.blackbox.BlackboxClient;

import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.mail.keyboard.rules.KeyboardRule;

import ru.yandex.search.rules.pure.ChainedSearchRule;
import ru.yandex.search.rules.pure.ResolveBackendsRule;
import ru.yandex.search.rules.pure.ResolveOAuthUserRule;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.BlackboxClientProvider;
import ru.yandex.search.rules.pure.providers.ProxySessionProvider;
import ru.yandex.search.rules.pure.providers.ProxySessionUserProvider;
import ru.yandex.search.rules.pure.providers.ProxySessionUserBackendsProvider;
import ru.yandex.search.rules.pure.providers.Tvm2TicketProvider;

public class KeyboardHandler implements ProxyRequestHandler {
    private final AsyncHttpServer server;
    private final SearchRule<OAuthContextProvider, KeyboardStats> rule;

    public KeyboardHandler(final AsyncHttpServer server) {
        this.server = server;
        rule =
            new ResolveOAuthUserRule<>(
                new ChainedSearchRule<>(
                    new ResolveBackendsRule<>(
                        new ChainedSearchRule<>(
                            new KeyboardRule<>(server.keyboardBackendClient()),
                            (input, backends) ->
                                new ProxySessionUserBackendsProvider(
                                    input.proxySession(),
                                    input.user(),
                                    backends)),
                        server.producerClient(),
                        server.searchMap()),
                    (input, user) -> new ProxySessionUserProvider(
                        input.proxySession(),
                        user)),
                server.config().keyboardOAuthScope(),
                (mdb, prefix) -> server.resolveService(mdb, prefix));
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        rule.execute(
            new OAuthContextProvider(server, session),
            new KeyboardSerpPrinter(session));
    }

    private static class OAuthContextProvider
        implements BlackboxClientProvider,
            ProxySessionProvider,
            Tvm2TicketProvider
    {
        private final AsyncHttpServer server;
        private final ProxySession session;

        OAuthContextProvider(
            final AsyncHttpServer server,
            final ProxySession session)
        {
            this.server = server;
            this.session = session;
        }

        @Override
        public BlackboxClient blackboxClient() {
            return server.blackboxClient(false, session.context());
        }

        @Override
        public ProxySession proxySession() {
            return session;
        }

        @Override
        public String tvm2Ticket() {
            return server.blackboxTvm2Ticket(false);
        }
    }
}

