package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import org.apache.http.HttpException;

import ru.yandex.blackbox.BlackboxClient;
import ru.yandex.blackbox.BlackboxUserinfo;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.mail.keyboard.rules.KeyboardRule;
import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;
import ru.yandex.search.rules.pure.ChainedSearchRule;
import ru.yandex.search.rules.pure.ResolveBackendsRule;
import ru.yandex.search.rules.pure.ResolveOAuthUserRule;
import ru.yandex.search.rules.pure.SearchRule;
import ru.yandex.search.rules.pure.providers.BlackboxClientProvider;
import ru.yandex.search.rules.pure.providers.ProxySessionProvider;
import ru.yandex.search.rules.pure.providers.ProxySessionUserBackendsProvider;
import ru.yandex.search.rules.pure.providers.ProxySessionUserProvider;
import ru.yandex.search.rules.pure.providers.Tvm2TicketProvider;
import ru.yandex.search.rules.pure.providers.UserProvider;

public class KeyboardHandlerNoAuth implements ProxyRequestHandler {
    private final AsyncHttpServer server;
    private final SearchRule<UserContextProvider, KeyboardStats> rule;

    public KeyboardHandlerNoAuth(final AsyncHttpServer server) {
        this.server = server;
        rule =
            new ResolveBackendsRule<>(
                new ChainedSearchRule<>(
                    new KeyboardRule<>(server.keyboardBackendClient()),
                    (input, backends) ->
                        new ProxySessionUserBackendsProvider(
                            input.proxySession(),
                            input.user(),
                            backends)),
                server.producerClient(),
                server.searchMap());
    }

    @Override
    public void handle(final ProxySession session) throws HttpException {
        rule.execute(
            new UserContextProvider(server, session),
            new KeyboardSerpPrinter(session));
    }

    private static class UserContextProvider
        implements UserProvider, ProxySessionProvider
    {
        private final AsyncHttpServer server;
        private final ProxySession session;
        private final User user;

        UserContextProvider(
            final AsyncHttpServer server,
            final ProxySession session)
            throws HttpException
        {
            this.server = server;
            this.session = session;

            long uid = session.params().getLong("uid");
            String service;
            if (BlackboxUserinfo.corp(uid)) {
                service = server.config().pgCorpQueue();
            } else {
                service = server.config().pgQueue();
            }
            this.user = new User(service, new LongPrefix(uid));
        }

        @Override
        public ProxySession proxySession() {
            return session;
        }

        @Override
        public User user() {
            return user;
        }
    }
}

