package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import java.io.IOException;
import java.io.OutputStreamWriter;

import java.nio.charset.CodingErrorAction;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NByteArrayEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxySession;

import ru.yandex.http.util.nio.NByteArrayEntityFactory;

import ru.yandex.io.DecodableByteArrayOutputStream;

import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonTypeExtractor;
import ru.yandex.json.writer.JsonWriter;

public class KeyboardSerpPrinter
    extends AbstractProxySessionCallback<KeyboardStats>
{
    private final JsonType jsonType;

    public KeyboardSerpPrinter(final ProxySession session)
        throws HttpException
    {
        super(session);
        jsonType = JsonTypeExtractor.NORMAL.extract(session.params());
    }

    private static void printWordsStat(
        final JsonWriter writer,
        final TopWords topWords)
        throws IOException
    {
        writer.startObject();
        writer.key("words-total");
        writer.value(topWords.totalWords());
        writer.key("frequency-total");
        writer.value(topWords.totalFreq());
        writer.key("exact-words-total");
        writer.value(topWords.totalExactWords());
        writer.key("exact-frequency-total");
        writer.value(topWords.totalExactFreq());
        WordFreq[] words = new WordFreq[topWords.size()];
        for (int i = words.length; i-- > 0;) {
            words[i] = topWords.poll();
        }
        writer.key("top-words");
        writer.startArray();
        for (WordFreq word: words) {
            writer.startObject();
            writer.key("word");
            writer.value(word.word());
            writer.key("frequency");
            writer.value(word.freq());
            writer.key("exact");
            writer.value(word.exact());
            writer.endObject();
        }
        writer.endArray();
        writer.endObject();
    }

    @Override
    public void completed(final KeyboardStats result) {
        TopWords topSubjectWords = result.subjectWords();
        TopWords topBodyWords = result.bodyWords();
        List<SenderInfo> senders = result.senders();
        session.logger().info(
            "Request completed, top subject words count: "
            + topSubjectWords.size()
            + ", top body words count: " + topBodyWords.size()
            + ", senders count: " + senders.size());
        DecodableByteArrayOutputStream out =
            new DecodableByteArrayOutputStream();
        try (OutputStreamWriter outWriter =
                new OutputStreamWriter(
                    out,
                    session.acceptedCharset().newEncoder()
                        .onMalformedInput(CodingErrorAction.REPLACE)
                        .onUnmappableCharacter(CodingErrorAction.REPLACE));
            JsonWriter writer = jsonType.create(outWriter))
        {
            writer.startObject();

            writer.key("subject-words");
            printWordsStat(writer, topSubjectWords);

            writer.key("body-words");
            printWordsStat(writer, topBodyWords);

            writer.key("contacts");
            writer.startArray();
            for (SenderInfo sender: senders) {
                writer.startObject();
                writer.key("email");
                writer.value(sender.normalizedEmail());
                writer.key("names");
                writer.startArray();
                for (String name: sender.names()) {
                    writer.value(name);
                }
                writer.endArray();
                writer.key("sent-count");
                writer.value(sender.sentCount());
                writer.key("received-count");
                writer.value(sender.receivedCount());
                writer.key("last-contacted");
                writer.value(sender.lastContacted());
                writer.endObject();
            }
            writer.endArray();

            writer.endObject();
        } catch (IOException e) {
            failed(e);
            return;
        }
        NByteArrayEntity entity =
            out.processWith(NByteArrayEntityFactory.INSTANCE);
        entity.setContentType(
            ContentType.APPLICATION_JSON.withCharset(session.acceptedCharset())
                .toString());
        session.response(HttpStatus.SC_OK, entity);
    }
}

