package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;

import ru.yandex.json.parser.JsonException;

import ru.yandex.json.writer.JsonType;

import ru.yandex.parser.string.CollectionParser;

public class SenderInfo {
    private static final CollectionParser<
        String,
        Set<String>,
        RuntimeException> NAMES_PARSER =
            new CollectionParser<>(x -> x, LinkedHashSet::new, '\n');

    private final String normalizedEmail;
    private final long lastContacted;
    private final long receivedCount;
    private final long sentCount;
    private final Set<String> names;

    public SenderInfo(final JsonObject doc)
        throws JsonException
    {
        try {
            JsonMap map = doc.asMap();
            String url = map.getString("url");
            int normalizedIndex = 0;
            for (int i = 0; i <= 2; ++i) {
                normalizedIndex = url.indexOf('_', normalizedIndex) + 1;
            }
            normalizedEmail = url.substring(normalizedIndex);
            lastContacted = map.getLong("senders_last_contacted", 0L);
            receivedCount = map.getLong("senders_received_count", 0L);
            sentCount = map.getLong("senders_sent_count", 0L);
            names = NAMES_PARSER.apply(map.getString("senders_names", ""));
            names.remove("");
            names.remove("0");
            names.remove(normalizedEmail);
        } catch (JsonException e) {
            throw new JsonException(
                "Failed to parse document: "
                + JsonType.HUMAN_READABLE.toString(doc),
                e);
        }
    }

    public String normalizedEmail() {
        return normalizedEmail;
    }

    public long lastContacted() {
        return lastContacted;
    }

    public long receivedCount() {
        return receivedCount;
    }

    public long sentCount() {
        return sentCount;
    }

    public Set<String> names() {
        return names;
    }
}

