package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import java.util.ArrayList;
import java.util.List;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericConsumer;

import ru.yandex.json.async.consumer.JsonAsyncConsumer;

import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.dom.TypesafePopValueContentHandler;

import ru.yandex.json.parser.ContentHandler;
import ru.yandex.json.parser.ExceptionHandlingContentHandler;
import ru.yandex.json.parser.InterningStringCollector;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.parser.SparseStringCollector;
import ru.yandex.json.parser.StackContentHandler;
import ru.yandex.json.parser.StringCollectors;

import ru.yandex.json.xpath.AnyIndexMatcher;
import ru.yandex.json.xpath.ListHandlerResolver;
import ru.yandex.json.xpath.NameMatcher;
import ru.yandex.json.xpath.XPathStackContentHandler;

public class SendersInfoConsumer extends JsonAsyncConsumer<List<SenderInfo>> {
    private final InfoConsumer info;

    public SendersInfoConsumer(final HttpEntity entity) throws HttpException {
        this(entity, new InfoConsumer());
    }

    private SendersInfoConsumer(
        final HttpEntity entity,
        final InfoConsumer info)
        throws HttpException
    {
        super(entity, createContentHandler(info));
        this.info = info;
    }

    private static ContentHandler createContentHandler(
        final InfoConsumer info)
    {
        InterningStringCollector interningCollector =
            new InterningStringCollector();
        SparseStringCollector sparseCollector = new SparseStringCollector();
        StringCollectors stringCollectors =
            new StringCollectors(interningCollector, sparseCollector);
        TypesafePopValueContentHandler infoHandler =
            new TypesafePopValueContentHandler(
                info,
                stringCollectors);
        StackContentHandler stackContentHandler = new StackContentHandler();
        infoHandler.stackContentHandler(stackContentHandler);
        XPathStackContentHandler xpathContentHandler =
            new XPathStackContentHandler(
                new ListHandlerResolver<>(
                    infoHandler,
                    new NameMatcher("hitsArray"),
                    AnyIndexMatcher.INSTANCE),
                stackContentHandler,
                interningCollector);
        stackContentHandler.push(xpathContentHandler);
        return new ExceptionHandlingContentHandler(
            new ExceptionHandlingContentHandler(
                stackContentHandler,
                stackContentHandler),
            xpathContentHandler);
    }

    @Override
    protected List<SenderInfo> doBuildResult(final HttpContext context)
        throws JsonException
    {
        return info;
    }

    private static class InfoConsumer
        extends ArrayList<SenderInfo>
        implements GenericConsumer<JsonObject, JsonException>
    {
        @Override
        public void accept(final JsonObject doc) throws JsonException {
            add(new SenderInfo(doc));
        }
    }
}

