package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.HttpStatusPredicates;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;
import ru.yandex.http.util.nio.StatusCheckAsyncResponseConsumerFactory;

public enum SendersInfoConsumerFactory
    implements HttpAsyncResponseConsumerFactory<List<SenderInfo>>
{
    INSTANCE;

    public static final HttpAsyncResponseConsumerFactory<List<SenderInfo>> OK =
        new StatusCheckAsyncResponseConsumerFactory<>(
            HttpStatusPredicates.OK,
            INSTANCE);

    @Override
    public SendersInfoConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new SendersInfoConsumer(response.getEntity());
    }
}

