package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import java.util.List;
import java.util.PriorityQueue;

import ru.yandex.json.xpath.PathComponent;
import ru.yandex.json.xpath.PrimitiveHandler;

public class TopWords
    extends PriorityQueue<WordFreq> implements PrimitiveHandler
{
    private static final long serialVersionUID = 0L;

    private final int topFreqs;
    private long totalFreq = 0L;
    private long totalExactFreq = 0L;
    private int totalWords = 0;
    private int totalExactWords = 0;

    public TopWords(final int topFreqs) {
        this.topFreqs = topFreqs;
    }

    public long totalFreq() {
        return totalFreq;
    }

    public int totalWords() {
        return totalWords;
    }

    public long totalExactFreq() {
        return totalExactFreq;
    }

    public int totalExactWords() {
        return totalExactWords;
    }

    @Override
    public void handle(
        final List<PathComponent> path,
        final Object value)
    {
        if (value instanceof Long && path.size() == 2) {
            if ("total-freq".equals(path.get(1).name())) {
                String token = path.get(0).name();
                int idx = token.indexOf('#') + 1;
                int len = token.length();
                int exactLen = len - 1;
                boolean exact = token.charAt(exactLen) == '"';
                if (exact) {
                    len = exactLen;
                }
                for (int i = idx; i < len; ++i) {
                    if (!Character.isLetter(token.charAt(i))) {
                        return;
                    }
                }
                String word = token.substring(idx, len);
                long freq = ((Long) value).longValue();
                totalFreq += freq;
                ++totalWords;
                if (exact) {
                    totalExactFreq += freq;
                    ++totalExactWords;
                }
                if (size() < topFreqs) {
                    add(new WordFreq(word, freq, exact));
                } else if (peek().compareTo(word, freq, exact) < 0) {
                    poll();
                    add(new WordFreq(word, freq, exact));
                }
            }
        }
    }
}

