package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.protocol.HttpContext;

import ru.yandex.json.async.consumer.JsonAsyncConsumer;

import ru.yandex.json.parser.StringCollectorsFactory;

public class TopWordsConsumer extends JsonAsyncConsumer<TopWords> {
    private final TopWords topWords;

    public TopWordsConsumer(final HttpEntity entity, final int topFreqs)
        throws HttpException
    {
        this(entity, new TopWords(topFreqs));
    }

    private TopWordsConsumer(final HttpEntity entity, final TopWords topWords)
        throws HttpException
    {
        super(entity, topWords, StringCollectorsFactory.INSTANCE);
        this.topWords = topWords;
    }

    @Override
    protected TopWords doBuildResult(final HttpContext context) {
        return topWords;
    }
}

