package ru.yandex.msearch.proxy.api.async.mail.keyboard;

import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;

import ru.yandex.http.util.nio.HttpAsyncResponseConsumerFactory;

public class TopWordsConsumerFactory
    implements HttpAsyncResponseConsumerFactory<TopWords>
{
    private final int topFreqs;

    public TopWordsConsumerFactory(final int topFreqs) {
        this.topFreqs = topFreqs;
    }

    @Override
    public TopWordsConsumer create(
        final HttpAsyncRequestProducer producer,
        final HttpResponse response)
        throws HttpException
    {
        return new TopWordsConsumer(response.getEntity(), topFreqs);
    }
}
