package ru.yandex.msearch.proxy.api.async.mail.keyboard;

public class WordFreq implements Comparable<WordFreq> {
    private final String word;
    private final long freq;
    private final boolean exact;

    public WordFreq(final String word, final long freq, final boolean exact) {
        this.word = word;
        this.freq = freq;
        this.exact = exact;
    }

    public String word() {
        return word;
    }

    public long freq() {
        return freq;
    }

    public boolean exact() {
        return exact;
    }

    @Override
    public int compareTo(final WordFreq other) {
        return compareTo(other.word, other.freq, other.exact);
    }

    public int compareTo(
        final String word,
        final long freq,
        final boolean exact)
    {
        int cmp = Long.compare(this.freq, freq);
        if (cmp == 0) {
            cmp = Boolean.compare(this.exact, exact);
            if (cmp == 0) {
                // Words ordering will be reversed, so in output it will be
                // ascending due to inversion
                cmp = word.compareTo(this.word);
            }
        }
        return cmp;
    }
}

