package ru.yandex.msearch.proxy.api.async.mail.legacy.search;

import java.util.Set;

import org.apache.http.HttpException;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;

import ru.yandex.msearch.proxy.api.async.mail.rules.AbstractSessionCallback;

import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;

public class LegacyImapSearchRule implements SearchRule {
    private final SearchRule next;

    public LegacyImapSearchRule(final SearchRule next) {
        this.next = next;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        String nearStr = session.params().getString("near", null);
        String nearField = null;
        String nearValue = null;
        if (nearStr != null) {
            int colonIndex = nearStr.indexOf(':');
            if (colonIndex > 0 && colonIndex < nearStr.length() - 1) {
                nearField = nearStr.substring(0, colonIndex);
                nearValue = nearStr.substring(colonIndex + 1);
                if ("mid_p".equalsIgnoreCase(nearField)) {
                    nearField = "mid";
                }
            }
        }

        Set<String> get = session.requestInfo().get();
        if (nearField == null || (get != null && !get.contains(nearField))) {
            session.httpSession().logger().warning(
                "Bad nearField " + nearField);
            next.execute(session);
        } else {
            next.execute(
                session.withCallback(
                    new ImapNearCallback(session, nearField, nearValue)));
        }
    }

    private final class ImapNearCallback
        extends AbstractSessionCallback<Documents>
    {
        private final String nearField;
        private final String nearValue;

        public ImapNearCallback(
            final SearchSession session,
            final String nearField,
            final String nearValue)
        {
            super(session);

            this.nearField = nearField;
            this.nearValue = nearValue;
        }

        @Override
        public void completed(final Documents groups) {
            int offset = session.requestInfo().offset();
            String baseLogStr =
                "Near field " + nearField + " nearValue " + nearValue;

            try {
                for (DocumentsGroup group: groups) {
                    Document doc = group.best();
                    if (nearValue.equalsIgnoreCase(
                        doc.doc().attrs().getOrDefault(nearField, null)))
                    {
                        session.params().replace(
                            "offset", String.valueOf(offset));
                        session.httpSession().logger().info(
                            baseLogStr + " found at offset " + offset);

                        next.execute(session);
                        return;
                    } else {
                        offset += 1;
                    }
                }

                session.httpSession().logger().info(
                    baseLogStr+ " not found at offset " + offset);

                session.params().replace("offset", String.valueOf(offset));
                next.execute(session.withCallback(this));
            } catch (HttpException e) {
                failed(e);
            }
        }
    }
}
