package ru.yandex.msearch.proxy.api.async.mail.legacy.search;

import java.io.IOException;
import java.util.Collections;
import java.util.List;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;

import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;

import org.apache.http.protocol.HttpContext;

import ru.yandex.function.GenericFunction;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.BasicSession;
import ru.yandex.msearch.proxy.api.async.Session;

import ru.yandex.msearch.proxy.api.async.mail.BasicSearchSession;
import ru.yandex.msearch.proxy.api.async.mail.DefaultSearchAttributes;
import ru.yandex.msearch.proxy.api.async.mail.MailSearchHandler;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.msearch.proxy.api.async.mail.SearchAttributes;

import ru.yandex.msearch.proxy.api.async.mail.rules.ImapSearchRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.ResolveUidRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.RewriteRequestRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.RuleContext;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;

import ru.yandex.msearch.proxy.api.async.mail.rules.SoCheckRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.StoreSearchRequestRule;

import ru.yandex.parser.config.ConfigException;

import ru.yandex.parser.string.PositiveIntegerValidator;
import ru.yandex.parser.uri.CgiParams;

public class LegacyMailSearchHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private final AsyncHttpServer server;
    private final SearchRule rule;

    public LegacyMailSearchHandler(
        final AsyncHttpServer server)
        throws ConfigException
    {
        this.server = server;

        this.rule = createRule(server);
    }

    public static SearchRule createRule(final AsyncHttpServer server) {
        RuleContext ruleContext =
            new RuleContext(
                server,
                MailSearchHandler.BasicDocumentsFactory.INSTANCE,
                LegacySearchAttributesFactory.INSTANCE);

        SearchRule plainSearchRule = new LegacyPlainSearchRule(ruleContext);

        SearchRule rule = new LegacySelectSearchRule(
            new RewriteRequestRule(server, plainSearchRule),
            new LegacyImapSearchRule(plainSearchRule));

        if (server.config().indexSearchRequests()
            && server.producerClient() != null)
        {
            rule = new StoreSearchRequestRule(rule, server);
        }

        if (server.config().soCheckConfig() != null) {
            rule = new SoCheckRule(rule, server);
        }

        rule = new ResolveUidRule(rule, server);

        return rule;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest httpRequest,
        final HttpContext httpContext)
        throws HttpException, IOException
    {
        return new BasicAsyncRequestConsumer();
    }

    protected void handleLegacyParams(
        final CgiParams params)
        throws BadRequestException
    {
        List<String> requests = params.remove("text");
        if (requests != null) {
            params.put("request", requests);
        }

        List<String> get = params.remove("getfields");
        params.put("get", get);

        List<String> user = params.remove("user");
        if (user != null && !user.isEmpty()) {
            params.put("uid", user);
        }

        List<String> mdb = params.remove("db");
        if (mdb != null && !mdb.isEmpty()) {
            params.put("mdb", mdb);
        }

        int length = params.get(
            "length",
            0,
            PositiveIntegerValidator.INSTANCE);

        int offset = params.getInt("offset", 0);
        if (offset < 0) {
            offset = 0;
            params.replace("offset", String.valueOf(offset));
        }

        params.put("count", Collections.singletonList(String.valueOf(length)));
        params.put("first", Collections.singletonList(String.valueOf(offset)));
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException, IOException
    {
        Session httpSession = new BasicSession(server, exchange, context);
        CgiParams params = new CgiParams(request);
        handleLegacyParams(params);

        RequestInfo requestInfo =
            new RequestInfo(httpSession, request, params);

        LegacySearchPrinter printer = new LegacySearchPrinter(requestInfo);
        rule.execute(new BasicSearchSession(requestInfo, params, printer));
    }

    private enum LegacySearchAttributesFactory
        implements GenericFunction<
        CgiParams,
        SearchAttributes,
        BadRequestException>
    {
        INSTANCE;

        @Override
        public SearchAttributes apply(final CgiParams params)
            throws BadRequestException
        {
            return new LegacySearchAttributes(params);
        }
    }

    private static class LegacySearchAttributes
        extends DefaultSearchAttributes
    {
        private final String get;

        private LegacySearchAttributes(
            final CgiParams params)
            throws BadRequestException
        {
            super(params);

            this.get = params.getString("get", "mid");
        }

        @Override
        public String luceneGet() {
            return get;
        }

        @Override
        public String luceneMergeFunc() {
            return "values";
        }
    }
}
