package ru.yandex.msearch.proxy.api.async.mail.legacy.search;

import java.util.function.Function;

import org.apache.http.HttpHost;
import org.apache.http.nio.protocol.HttpAsyncRequestProducer;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.msearch.proxy.api.async.mail.SearchRequest;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.direct.SimplePlainSearchCallback;
import ru.yandex.msearch.proxy.api.async.mail.direct.SimplePlainSearchRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.AbstractPlainSearchCallback;
import ru.yandex.msearch.proxy.api.async.mail.rules.RuleContext;

public class LegacyPlainSearchRule extends SimplePlainSearchRule {
    public LegacyPlainSearchRule(final RuleContext context) {
        super(context);
    }

    @Override
    protected AbstractPlainSearchCallback createCallback(
        final SearchSession session,
        final SearchRequest request)
        throws BadRequestException
    {
        return new LegacyPLainSearchCallback(session, context, request);
    }

    private static final class LegacyPLainSearchCallback
        extends SimplePlainSearchCallback
    {
        private final int offset;
        private final int length;

        public LegacyPLainSearchCallback(
            final SearchSession session,
            final RuleContext context,
            final SearchRequest request)
            throws BadRequestException
        {
            super(session, context, request);

            this.offset =
                session.params().getInt(
                    "offset",
                    session.requestInfo().offset());
            this.length =
                session.params().getInt(
                    "length",
                    session.requestInfo().length());
        }

        @Override
        protected Function<? super HttpHost, ? extends HttpAsyncRequestProducer> nextRequest() {
            StringBuilder sb = new StringBuilder(request.luceneRequest());
            sb.append("&length=");
            sb.append(length);
            sb.append("&offset=");
            sb.append(offset);
            return new BasicAsyncRequestProducerGenerator(sb.toString());
        }
    }
}
