package ru.yandex.msearch.proxy.api.async.mail.legacy.search;

import org.apache.http.HttpException;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;

public class LegacySelectSearchRule implements SearchRule {
    private final SearchRule defaultSearchRule;
    private final SearchRule imapSearchRule;

    public LegacySelectSearchRule(
        final SearchRule defaultSearchRule,
        final SearchRule imapSearchRule)
    {
        this.defaultSearchRule = defaultSearchRule;
        this.imapSearchRule = imapSearchRule;
    }

    @Override
    public void execute(final SearchSession session) throws HttpException {
        if (session.params().getBoolean("imap", false)) {
            imapSearchRule.execute(session);
        } else {
            defaultSearchRule.execute(session);
        }
    }
}
