package ru.yandex.msearch.proxy.api.async.mail.ml;

import java.io.IOException;
import java.util.Collections;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.nio.protocol.BasicAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.BasicSession;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.parser.uri.CgiParams;

public class MLSearchHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    // @tmalikova said that they have 10s timeout but front has 5s timeout, 200ms leave spare
    private static final int BACKEND_TIMEOUT = 4550;

    private final AsyncHttpServer server;
    private final MailingsResolveByUidRule rule;

    public MLSearchHandler(
        final AsyncHttpServer server)
        throws IOException
    {
        this.server = server;

        this.rule = new MailingsResolveByUidRule(server, new MailingsSearchRule(server));
    }

    @Override
    public BasicAsyncRequestConsumer processRequest(
        final HttpRequest request,
        final HttpContext context)
    {
        return new BasicAsyncRequestConsumer();
    }

    @Override
    public String toString() {
        return "Performs search in user allowed subscriptions";
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        BasicSession httpSession = new BasicSession(server, exchange, context);
        CgiParams params = httpSession.params();
        long deadline = System.currentTimeMillis() + BACKEND_TIMEOUT;
        params.putIfAbsent("deadline", Collections.singletonList(String.valueOf(deadline)));

        RequestInfo requestInfo =
            new RequestInfo(httpSession, request, params);

        MLResultPrinter printer;
        printer = new MLResultPrinter(requestInfo);

        MlSearchSession session = new MlSearchSession(requestInfo, httpSession, printer);
        rule.execute(session);
    }
}

