package ru.yandex.msearch.proxy.api.async.mail.ml;

import ru.yandex.parser.searchmap.User;
import ru.yandex.search.prefix.LongPrefix;

class Mailing extends User implements Comparable<Mailing> {
    private final long id;
    private final long uid;
    private final String name;
    private final String email;
    private volatile MailingWeight weight;

    public Mailing(
        final long id,
        final LongPrefix prefix,
        final String name,
        final String email,
        final String service,
        final MailingWeight weight)
    {
        super(service, prefix);
        this.id = id;
        this.uid = prefix.prefix();
        this.name = name;
        this.email = email;
        this.weight = weight;
    }

    @Override
    public int compareTo(final Mailing o) {
        return o.weight.compareTo(this.weight);
    }

    public long id() {
        return id;
    }

    public long uid() {
        return uid;
    }

    public String name() {
        return name;
    }

    public String email() {
        return email;
    }

    public MailingWeight weight() {
        return weight;
    }

    public Mailing weight(final MailingWeight weight) {
        this.weight = weight;
        return this;
    }

    @Override
    public String toString() {
        return "Mailing{" +
            "id=" + id +
            ", uid=" + uid +
            ", name='" + name + '\'' +
            ", email='" + email + '\'' +
            ", weight=" + weight +
            '}';
    }
}
