package ru.yandex.msearch.proxy.api.async.mail.ml;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;

import org.apache.http.HttpException;

import ru.yandex.http.util.AbstractFilterFutureCallback;
import ru.yandex.json.dom.JsonList;
import ru.yandex.json.dom.JsonMap;
import ru.yandex.json.dom.JsonObject;
import ru.yandex.json.parser.JsonException;
import ru.yandex.json.writer.JsonType;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;

public class MailingListCallback extends AbstractFilterFutureCallback<JsonObject, Documents> {
    private final MlSearchSession searchSession;
    private final MailingParser parser;
    private final MailingsSearchRule rule;

    public MailingListCallback(
        final MlSearchSession session,
        final MailingsSearchRule rule,
        final MailingParser parser)
    {
        super(session.callback());

        this.searchSession = session;
        this.parser = parser;
        this.rule = rule;
    }

    @Override
    public void completed(final JsonObject response) {
        Map<Long, Mailing> mailingMap = new LinkedHashMap<>();
        try {
            JsonMap map = response.asMap();
            JsonList subscribed = map.getList("subscribed_to");
            int parseError = 0;
            JsonException lastException = null;
            for (JsonObject item: subscribed) {
                // https://st.yandex-team.ru/ISEARCH-6552
                try {
                    Mailing mailing = parser.parseWithWeight(item.asMap(), 1);
                    mailingMap.put(mailing.uid(), mailing);
                } catch (JsonException je) {
                    lastException = je;
                    parseError += 1;
                    searchSession.logger().log(
                        Level.WARNING,
                        "Failed to parse mailing " + JsonType.NORMAL.toString(item),
                        je);
                }
            }
            if (parseError == subscribed.size() && parseError > 0) {
                throw lastException;
            }

            if (parseError > 0) {
                searchSession.logger().warning(
                    "Mailing parse error count " + parseError + '/' + subscribed.size());
            }

            JsonList owner = map.getListOrNull("owner_of");
            if (owner != null) {
                for (JsonObject item: owner) {
                    try {
                        Mailing mailing = parser.parseWithWeight(item.asMap(), 5);
                        mailingMap.put(mailing.uid(), mailing);
                    } catch (JsonException je) {
                        searchSession.logger().warning(
                            "Failed to parse mailing " + JsonType.NORMAL.toString(item));
                    }
                }
            }

            JsonList open = map.getList("open");

            for (JsonObject item: open) {
                try {
                    Mailing mailing = parser.parseWithWeight(item.asMap());
                    if (mailing != null) {
                        mailingMap.put(mailing.uid(), mailing);
                    }
                } catch (JsonException je) {
                    searchSession.logger().warning(
                        "Failed to parse mailing " + JsonType.NORMAL.toString(item));
                }
            }
        } catch (JsonException e) {
            failed(e);
            return;
        }

        try {
            rule.execute(searchSession, new UserMailings(mailingMap));
        } catch (HttpException e) {
            failed(e);
        }
    }
}
