package ru.yandex.msearch.proxy.api.async.mail.ml;

public class MailingWeight implements Comparable<MailingWeight> {
    public static final MailingWeight MAX_WEIGHT = new MailingWeight(Integer.MAX_VALUE, Integer.MAX_VALUE);

    private final int openRate;
    private final int lastMailAndPeopleSenderRate;

    public MailingWeight(final int openRate, final int lastMailAndPeopleSenderRate) {
        this.openRate = openRate;
        this.lastMailAndPeopleSenderRate = lastMailAndPeopleSenderRate;
    }

    @Override
    public int compareTo(final MailingWeight o) {
        int cmp = Integer.compare(openRate, o.openRate);
        if (cmp != 0) {
            return cmp;
        }

        return Integer.compare(lastMailAndPeopleSenderRate, o.lastMailAndPeopleSenderRate);
    }

    public int openRate() {
        return openRate;
    }

    public int lastMailAndPeopleSenderRate() {
        return lastMailAndPeopleSenderRate;
    }

    @Override
    public String toString() {
        return "MailingWeight{" +
            "or=" + openRate +
            ", oldrank=" + lastMailAndPeopleSenderRate +
            '}';
    }
}
