package ru.yandex.msearch.proxy.api.async.mail.ml;

import org.apache.http.HttpException;
import org.apache.http.HttpHost;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.json.async.consumer.JsonAsyncTypesafeDomConsumerFactory;
import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;

public class MailingsResolveByUidRule {
    private static final String GET_MAILLISTS = "/apiv3/lists/staff_maillists?&uid=";

    private final AsyncClient mlClient;
    private final HttpHost mlHost;
    private final MailingsSearchRule nextRule;
    private final MailingParser mailingParser;

    public MailingsResolveByUidRule(
        final AsyncHttpServer server,
        final MailingsSearchRule nextRule)
    {
        this.nextRule = nextRule;
        this.mlClient = server.corpMlClient();
        this.mlHost = server.config().corpMlConfig().host();
        this.mailingParser = new MailingParser(server, server.logger());
    }

    public void execute(final MlSearchSession session) throws HttpException {
        long uid = session.params().getLong("uid");
        BasicAsyncRequestProducerGenerator generator =
            new BasicAsyncRequestProducerGenerator(
                GET_MAILLISTS + uid);

        AsyncClient client = mlClient.adjust(session.session().context());

        client.execute(
            mlHost,
            generator,
            JsonAsyncTypesafeDomConsumerFactory.OK,
            session.session().listener()
                .createContextGeneratorFor(client),
            new MailingListCallback(session, nextRule, mailingParser));
    }
}
