package ru.yandex.msearch.proxy.api.async.mail.ml;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import ru.yandex.msearch.proxy.api.async.mail.SingleFieldSortOrder;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;

public class MlSearchDocuments implements Documents {
    protected final Map<String, MlDocumentsGroup> groups;
    protected int total = 0;
    protected int size = 0;

    public MlSearchDocuments() {
        groups = new LinkedHashMap<>();
    }

    @Override
    public void add(final String groupId, final Document doc) {
        throw new UnsupportedOperationException();
    }

    public void add(final Mailing mailing, final List<Document> documents) {
        total += documents.size();
        String id = String.valueOf(mailing.id());
        MlDocumentsGroup group = groups.get(id);
        for (Document document: documents) {
            if (group == null) {
                group = new MlDocumentsGroup(mailing, SingleFieldSortOrder.DEFAULT, document);
                groups.put(id, group);
            } else {
                group.add(document);
            }

            size += 1;
        }
    }

    public void add(final Mailing mailing, final Documents documents) {
        total += documents.total();
        String id = String.valueOf(mailing.id());
        MlDocumentsGroup group = groups.get(id);
        for (DocumentsGroup document: documents) {
            if (group == null) {
                group = new MlDocumentsGroup(mailing, documents.comparator(), document.best());
                groups.put(id, group);
            } else {
                group.add(document.best());
            }

            size += 1;
        }
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public void clear() {
        groups.clear();
        size = 0;
        total = 0;
    }

    @Override
    public List<? extends DocumentsGroup> sort() {
        List<MlDocumentsGroup> values = new ArrayList<>(groups.values());
        values.sort(MlGroupComparator.INSTANCE);
        return values;
    }

    @Override
    public long relevant() {
        return 0;
    }

    @Override
    public void total(long total) {

    }

    @Override
    public long total() {
        return total;
    }

    @Override
    public Comparator<Document> comparator() {
        return null;
    }

    @Override
    public Iterator<DocumentsGroup> iterator() {
        List<DocumentsGroup> groups = new ArrayList<>(this.groups.size());

        for (MlDocumentsGroup group: this.groups.values()) {
            groups.add(group);
        }

        return groups.iterator();
    }

    public Map<String, ? extends DocumentsGroup> groups() {
        return groups;
    }

    public List<Document> sorted() {
        List<Document> result = new ArrayList<>(size());
        for (DocumentsGroup group: groups.values()) {
            for (Document doc: group) {
                result.add(doc);
            }
        }

        result.sort(SingleFieldSortOrder.DEFAULT);
        return result;
    }

}
