package ru.yandex.msearch.proxy.api.async.mail.ml;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.BasicSession;
import ru.yandex.msearch.proxy.api.async.Session;
import ru.yandex.msearch.proxy.api.async.mail.BasicSearchSession;
import ru.yandex.msearch.proxy.api.async.mail.RequestInfo;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.documents.Documents;
import ru.yandex.parser.uri.CgiParams;

public class MlSearchSession implements SearchSession {
    private final RequestInfo requestInfo;
    private final CgiParams params;
    private final BasicSession session;
    private final FutureCallback<? super Documents> callback;

    public MlSearchSession(
        final RequestInfo requestInfo,
        final BasicSession session,
        final FutureCallback<? super Documents> callback)
    {
        this.requestInfo = requestInfo;
        this.params = session.params();
        this.callback = callback;
        this.session = session;
    }

    @Override
    public RequestInfo requestInfo() {
        return requestInfo;
    }

    @Override
    public Session httpSession() {
        return session;
    }

    public ProxySession session() {
        return session;
    }

    public PrefixedLogger logger() {
        return session.logger();
    }

    @Override
    public CgiParams params() {
        return params;
    }

    @Override
    public FutureCallback<? super Documents> callback() {
        return callback;
    }

    @Override
    public SearchSession copy() {
        return new BasicSearchSession(
            requestInfo,
            new CgiParams(params),
            callback);
    }

    @Override
    public SearchSession withCallback(
        final FutureCallback<? super Documents> callback)
    {
        return new BasicSearchSession(requestInfo, params, callback);
    }
}

