package ru.yandex.msearch.proxy.api.async.mail.ml;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;

public class UserMailings {
    private final Map<Long, Mailing> uidMailingMap;
    private final Map<String, Mailing> nameMailingMap;

    public UserMailings(final Map<Long, Mailing> map) {
        this.uidMailingMap = map;
        Map<String, Mailing> nameMap = new LinkedHashMap<>();
        for (Map.Entry<Long, Mailing> entry: map.entrySet()) {
            nameMap.put(entry.getValue().name(), entry.getValue());
        }

        this.nameMailingMap = nameMap;
    }

    public Mailing get(final Long uid) {
        return uidMailingMap.get(uid);
    }

    public Collection<Mailing> values() {
        return uidMailingMap.values();
    }

    public Mailing get(final String name) {
        return nameMailingMap.get(name);
    }
}
