package ru.yandex.msearch.proxy.api.async.mail.relevance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;

public abstract class AbstractFactorGroupFactory implements FactorGroupFactory {
    public static final Comparator<FactorFactoryAttributes> INDEX_CMP =
        new Comparator<FactorFactoryAttributes>() {

            @Override
            public int compare(
                final FactorFactoryAttributes o1, final FactorFactoryAttributes o2)
            {
                return Integer.compare(o1.index(), o2.index());
            }
        };

    protected final List<String> names = new ArrayList<>();
    private final String groupName;
    private final int startIndex;
    private final int size;

    public AbstractFactorGroupFactory(
        final String groupName,
        final int startIndex,
        final int size)
    {
        this.groupName = groupName;
        this.startIndex = startIndex;
        this.size = size;
    }

    public AbstractFactorGroupFactory(
        final String groupName,
        final FactorFactoryAttributes[] factories)
    {
        Arrays.sort(factories, INDEX_CMP);

        this.startIndex = factories[0].index();
        this.size = factories.length;
        this.groupName = groupName;

        for (FactorFactoryAttributes factory: factories) {
            this.names.add(factory.groupName());
        }
    }

    @Override
    public List<String> names() {
        return names;
    }

    @Override
    public int startIndex() {
        return startIndex;
    }

    @Override
    public int size() {
        return size;
    }

    @Override
    public String groupName() {
        return groupName;
    }
}
