package ru.yandex.msearch.proxy.api.async.mail.relevance;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.logger.PrefixedLogger;

import ru.yandex.parser.uri.CgiParams;

public abstract class AbstractRelevanceSorter<T> implements RelevanceSorter {
    // num documents to be ranked by model
    protected final List<FactorGroup<T>> factors;
    protected final int factorsLength;
    protected final int[] logIndexes;
    protected final List<String> factorNames;
    protected final PrefixedLogger logger;

    public AbstractRelevanceSorter(
        final FactorsContext<T> context,
        final CgiParams params,
        final PrefixedLogger logger)
    {
        this.factors = new ArrayList<>(context.factories().size());
        this.factorNames = context.names();
        this.logIndexes = context.logIndexes();
        this.logger = logger;

        context.factories().forEach(
            (k, v) -> factors.add(v.create(params, logger)));

        this.factorsLength = context.names().size();
    }

    public void prepare(final T doc, final String request) {
        for (FactorGroup<T> factor: factors) {
            if (!factor.normalized()) {
                factor.prepare(doc, request);
            }
        }
    }

    @Override
    public List<String> names() {
        return factorNames;
    }

    @Override
    public int[] logIndexes() {
        return logIndexes;
    }
}
