package ru.yandex.msearch.proxy.api.async.mail.relevance;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractSorterFactory<T, D> implements SorterFactory<T> {
    protected Map<String, FactorGroupFactory<D>> factories;
    protected List<String> names;
    protected int[] indexes;
    protected String name;

    public AbstractSorterFactory(
        final String name,
        final List<FactorGroupFactory<D>> factors,
        final List<FactorGroupFactory<D>> logFactors)
    {
        this.set(factors, logFactors);

        this.name = name;
    }

    public String name() {
        return name;
    }

    protected AbstractSorterFactory<T, D> set(
        final List<FactorGroupFactory<D>> factors,
        final List<FactorGroupFactory<D>> logFactors)
    {
        List<FactorGroupFactory> combined = new ArrayList<>();
        combined.addAll(factors);
        combined.addAll(logFactors);

        factories = new HashMap<>();
        int maxIndex = 0;
        for (FactorGroupFactory fgf: combined) {
            factories.put(fgf.groupName(), fgf);
            if (fgf.endIndex() > maxIndex) {
                maxIndex = fgf.endIndex();
            }
        }

        String[] namesArr = new String[maxIndex + 1];

        for (FactorGroupFactory fgf: combined) {
            for (int i = fgf.startIndex(); i <= fgf.endIndex(); i++) {
                namesArr[i] = fgf.names().get(i - fgf.startIndex());
            }
        }

        names = Arrays.asList(namesArr);
        List<Integer> logIndexes = new ArrayList<>();

        for (FactorGroupFactory fgf: logFactors) {
            for (String name: fgf.names()) {
                logIndexes.add(names.indexOf(name));
            }
        }

        indexes = new int[logIndexes.size()];
        for (int i = 0; i < logIndexes.size(); i++) {
            indexes[i] = logIndexes.get(i);
        }

        return this;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + '[' + name + ']';
    }
}
