package ru.yandex.msearch.proxy.api.async.mail.relevance;

import ru.yandex.matrixnet.BasicMatrixnetModel.MatrixnetModelParseException;
import ru.yandex.matrixnet.BoostableMatrixnetModel;
import ru.yandex.matrixnet.ImmutableMatrixnetModelConfig;
import ru.yandex.matrixnet.MatrixnetModel;

public class BogdanHappinessModel implements MatrixnetModel {
    public static final int EMAIL_IDX = 4;
    public static final int FROM_NAME_IN_REQ_IDX = 6;
    public static final int FROM_EMAIL_IN_REQ_IDX = 7;

    private final BoostableMatrixnetModel model;
    private final int[] indicies = {
        FROM_NAME_IN_REQ_IDX,
        FROM_EMAIL_IN_REQ_IDX
    };

    public BogdanHappinessModel(
        final ImmutableMatrixnetModelConfig config)
        throws MatrixnetModelParseException
    {
        this.model = new BoostableMatrixnetModel(
            config, indicies, BogdanHappinessModel::requestInSubject);
    }

    @Override
    public double score(final double[] factors) {
        return model.score(factors);
    }

    private static boolean requestInSubject(final double[] factors) {
        return factors[EMAIL_IDX] > 0;
    }

    @Override
    public String name() {
        return model.name();
    }
}
