package ru.yandex.msearch.proxy.api.async.mail.relevance;

import ru.yandex.http.util.BadRequestException;

import ru.yandex.msearch.proxy.AsyncHttpServer;

import ru.yandex.msearch.proxy.api.async.mail.rules.PersonalFactorsGatherRule;
import ru.yandex.msearch.proxy.api.async.mail.rules.SearchRule;

import ru.yandex.parser.uri.CgiParams;

public class DirectPersonalFactorsGatherRule extends PersonalFactorsGatherRule {
    public DirectPersonalFactorsGatherRule(
        final SearchRule next,
        final AsyncHttpServer server,
        final PersonalFactorsProcessorFactory... factories)
    {
        super(next, server, factories);
    }

    @Override
    protected void adjustParams(final CgiParams params) {
    }

    @Override
    protected boolean enabled(
        final CgiParams params)
        throws BadRequestException
    {
        if (!params.getBoolean("ranking", false)) {
            return false;
        }

        return true;
    }
}
