package ru.yandex.msearch.proxy.api.async.mail.relevance;

import ru.yandex.json.parser.JsonException;

public interface Factor<T> extends NormalizedFactorGroup<T> {
    int index();

    double calc(final T doc, final String request)
        throws RelevanceException, JsonException;

    @Override
    default void calc(
        final T doc,
        final String request,
        final double[] res)
        throws RelevanceException, JsonException
    {
        if (res != null) {
            res[index()] = calc(doc, request);
        }
    }
}
