package ru.yandex.msearch.proxy.api.async.mail.relevance;

import java.util.List;
import java.util.Map;

public class FactorsContext<T> {
    private final Map<String, FactorGroupFactory<T>> factories;

    private final List<String> names;
    private final int[] logIndexes;

    public FactorsContext(
        final Map<String, FactorGroupFactory<T>> factories,
        final List<String> names,
        final int[] logIndexes)
    {
        this.factories = factories;
        this.names = names;
        this.logIndexes = logIndexes;
    }

    public Map<String, FactorGroupFactory<T>> factories() {
        return factories;
    }

    public List<String> names() {
        return names;
    }

    public int[] logIndexes() {
        return logIndexes;
    }
}
