package ru.yandex.msearch.proxy.api.async.mail.relevance;

import ru.yandex.dbfields.MailIndexFields;

import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.searcher.PlainSearcher;

import ru.yandex.parser.searchmap.User;

import ru.yandex.parser.uri.QueryConstructor;

import ru.yandex.search.request.util.SearchRequestText;

import ru.yandex.search.result.SearchResult;

public class FuzzyRequestMidProcessorFactory
    implements PersonalFactorsProcessorFactory
{
    public static final FuzzyRequestMidProcessorFactory INSTANCE =
        new FuzzyRequestMidProcessorFactory();

    private static final String GET_FIELDS =
        String.join(
            ",",
            MailIndexFields.REQUEST_MIDS,
            MailIndexFields.REQUEST_DATE,
            MailIndexFields.REQUEST_COUNT);

    @Override
    public PersonalFactorsProcesor create(
        final SearchSession session,
        final User user,
        final PlainSearcher<SearchResult> searcher)
    {
        return new FuzzyRequestMidProcessor(session, user, searcher);
    }

    private static final class FuzzyRequestMidProcessor
        extends RequestMidProcessorFactory.RequestMidProcessor
    {
        public FuzzyRequestMidProcessor(
            final SearchSession session,
            final User user,
            final PlainSearcher<SearchResult> searcher)
        {
            super(session, user, searcher);
        }

        @Override
        protected BasicAsyncRequestProducerGenerator request(
            final String userRequest)
            throws BadRequestException
        {
            QueryConstructor qc = new QueryConstructor("/search?");
            String escapedRequest =
                SearchRequestText.fullEscape(userRequest, true);
            qc.append("get", GET_FIELDS);
            qc.append("text", "request_raw:" + escapedRequest + "*");
            qc.append("prefix", user.prefix().toString());
            qc.append("service", user.service());
            qc.append("sort", "request_date");
            return new BasicAsyncRequestProducerGenerator(qc.toString());
        }
    }
}
