package ru.yandex.msearch.proxy.api.async.mail.relevance;

import java.util.List;

import ru.yandex.matrixnet.MatrixnetModel;

import ru.yandex.msearch.proxy.config.ImmutableRelevanceConfig;

import ru.yandex.parser.config.ConfigException;

public abstract class MatrixnetSorterFactory<T, D>
    extends AbstractSorterFactory<T, D>
{
    private final MatrixnetModel model;
    private final ImmutableRelevanceConfig modelConfig;

    public MatrixnetSorterFactory(
        final ImmutableRelevanceConfig config,
        final List<FactorGroupFactory<D>> factors,
        final List<FactorGroupFactory<D>> logFactors)
        throws ConfigException
    {
        super(config.name(), factors, logFactors);

        this.modelConfig = config;
        this.model = config.buildModel();
    }

    public ImmutableRelevanceConfig modelConfig() {
        return modelConfig;
    }

    public MatrixnetModel model() {
        return model;
    }
}
