package ru.yandex.msearch.proxy.api.async.mail.relevance;

import java.util.logging.Level;

import org.apache.http.concurrent.FutureCallback;

import ru.yandex.function.GenericConsumer;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.nio.BasicAsyncRequestProducerGenerator;

import ru.yandex.json.parser.JsonException;
import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.searcher.PlainSearcher;

import ru.yandex.parser.searchmap.User;

import ru.yandex.search.result.SearchResult;

public abstract class PersonalFactorsProcesor
    implements GenericConsumer<Document, JsonException>,
    FutureCallback<SearchResult>
{
    protected final SearchSession session;
    protected final User user;
    protected final PlainSearcher<SearchResult> searcher;
    protected final PrefixedLogger logger;

    public PersonalFactorsProcesor(
        final SearchSession session,
        final User user,
        final PlainSearcher<SearchResult> searcher)
    {
        this.session = session;
        this.user = user;
        this.searcher = searcher;
        this.logger = session.httpSession().logger().addPrefix(name());
    }

    protected abstract String name();

    protected abstract BasicAsyncRequestProducerGenerator request(
        final String userRequest)
        throws BadRequestException;

    protected boolean enabled(final String request) {
        return request != null;
    }

    public void execute() throws BadRequestException {
        String request = session.requestInfo().options().request();
        if (enabled(request)) {
            searcher.search(request(request), this);
        } else {
            logger.info(this.getClass().getSimpleName() + " disabled");
        }
    }

    @Override
    public void failed(final Exception e) {
        logger.log(
            Level.WARNING,
            "Personal factors request failed",
            e);
    }

    @Override
    public void cancelled() {
        logger.warning("Personal factors request cancelled");
    }
}
