package ru.yandex.msearch.proxy.api.async.mail.relevance;

import java.util.Map;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.mail.Product;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.msearch.proxy.api.async.mail.Side;
import ru.yandex.msearch.proxy.experiment.UserSplit;
import ru.yandex.parser.uri.CgiParams;

public interface RelevanceFactory<T extends SorterFactory<?>> {
    T create(
        final CgiParams params,
        final PrefixedLogger logger,
        final UserSplit userSplit,
        final Side side,
        final Product product);

    default T create(
        final SearchSession session,
        final UserSplit userSplit)
    {
        return create(
            session.params(),
            session.httpSession().logger(),
            userSplit,
            session.requestInfo().options().side(),
            session.requestInfo().options().product());
    }

    default T create(
        final ProxySession session,
        final UserSplit userSplit,
        final Side side,
        final Product product)
    {
        return create(
            session.params(),
            session.logger(),
            userSplit,
            side,
            product);
    }

    Map<String, ? extends Object> status(boolean verbose);
}
