package ru.yandex.msearch.proxy.api.async.mail.relevance;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.logger.PrefixedLogger;
import ru.yandex.msearch.proxy.api.async.mail.SearchSession;
import ru.yandex.parser.uri.CgiParams;

public interface SorterFactory<T> {
    T build(final CgiParams params, final PrefixedLogger logger);

    default T build(final ProxySession session) {
        return build(session.params(), session.logger());
    }

    default T build(final SearchSession session) {
        return build(session.params(), session.httpSession().logger());
    }

    String name();
}
