package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import java.util.ArrayList;
import java.util.List;

import ru.yandex.json.parser.JsonException;
import ru.yandex.logger.PrefixedLogger;

import ru.yandex.msearch.proxy.api.async.mail.documents.Document;
import ru.yandex.msearch.proxy.api.async.mail.documents.DocumentsGroup;

import ru.yandex.msearch.proxy.api.async.mail.relevance.AbstractRelevanceSorter;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorsContext;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroup;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RelevanceException;

import ru.yandex.msearch.proxy.logger.ProxyTskvLogger;
import ru.yandex.parser.uri.CgiParams;

public abstract class AbstractMailSearchRelevanceSorter
    extends AbstractRelevanceSorter<Document>
{
    protected final MailSearchRelevanceFactory relevanceFactory;

    public AbstractMailSearchRelevanceSorter(
        final MailSearchRelevanceFactory factory,
        final FactorsContext<Document> context,
        final CgiParams params,
        final PrefixedLogger logger)
    {
        super(context, params, logger);

        this.relevanceFactory = factory;
    }

    protected List<RankedDocument> prepare(
        final List<? extends DocumentsGroup> docs,
        final String request)
    {
        List<RankedDocument> rankedDocs = new ArrayList<>();

        int pos = 1;

        for (DocumentsGroup group: docs) {
            for (Document doc: group) {
                prepare(doc, request);
                rankedDocs.add(new RankedDocument(doc, pos));
                ++pos;
            }
        }

        return rankedDocs;
    }

    public double[] calculate(final Document doc, final String request)
        throws RelevanceException, JsonException
    {
        double[] values = new double[factorsLength];
        for (FactorGroup<Document> factor: factors) {
            factor.calc(doc, request, values);
        }

        return values;
    }

    public ProxyTskvLogger factorsLogger() {
        return relevanceFactory.factorsLogger();
    }

    public boolean topRelevant() {
        return relevanceFactory.topRelevant();
    }

    public boolean rankEmailRequests() {
        return relevanceFactory.rankEmailRequests();
    }

    public abstract int minSerpSize();

    public abstract int rankedPositions();

    public abstract List<RankedDocument> sort(
        final List<? extends DocumentsGroup> docs,
        final String request)
        throws RelevanceException, JsonException;
}
