package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;

import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import ru.yandex.msearch.proxy.AsyncHttpServer;
import ru.yandex.msearch.proxy.api.async.mail.documents.Document;

import ru.yandex.msearch.proxy.api.async.mail.relevance.AbstractRelevanceFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.MtypeRequestProcessorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.RequestMidProcessorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.ClickFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.DaytimeFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.DocFieldFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.FactorGroupFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.FidFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.LuceneFieldFactorFactory;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.MessageTypesFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.NormalizedClickFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.RequestSubjectFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.WeekdayFactorFactory;

import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.PlainReceiveDateFactorFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email.AnyEmailInRequestFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email.BinaryDisplayInRequestFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email.BinaryEmailInRequestFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email.DisplayInRequestFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email.EmailGroupFactory;
import ru.yandex.msearch.proxy.api.async.mail.relevance.search.factors.email.EmailInRequestFactory;

import ru.yandex.msearch.proxy.config.ImmutableRankingConfig;
import ru.yandex.msearch.proxy.config.ImmutableRelevanceConfig;

import ru.yandex.msearch.proxy.ora.wmi.fields.WmiField;

import ru.yandex.parser.config.ConfigException;

public class BasicMailSearchRelevanceFactory
    extends AbstractRelevanceFactory<MailSearchSorterFactory, Document>
    implements MailSearchRelevanceFactory
{
    private static final Map<String, FactorGroupFactory<Document>> MAIL_FACTORS =
        new LinkedHashMap<>();
    private static int startIndex = 0;

    public static final String TOTAL_CLICKS = "total_clicks";
    public static final String SERP_CLICKS = "serp_clicks";
    public static final String EMAIL = "request_email";
    public static final String RECEIVED_DATE = "age";
    public static final String RECEIVED_DATE_PLAIN = "age_p";
    public static final String FROM_EMAIL_IN_REQUEST = "from_email_in_req";
    public static final String FROM_NAME_IN_REQUEST = "from_name_in_req";
    public static final String TO_EMAIL_IN_REQUEST = "to_email_in_req";
    public static final String TO_NAME_IN_REQUEST = "to_name_in_req";
    public static final String FID = "fid";
    public static final String REQUEST_IN_SUBJECT = "req_in_subj";
    public static final String TYPE_SOCIAL = "mtype_social";
    public static final String TYPE_PEOPLE = "mtype_people";
    public static final String TYPE_NEWS = "mtype_news";
    public static final String TYPE_PERSONAL = "mtype_personal";
    public static final String LUCENE_SCORE = "lcn_score";
    public static final String USER_MTYPE_FREQ = "mtype_freq";
    public static final String NORMALIZED_TOTAL_CLICK = "total_clicks_n";
    public static final String NORMALIZED_SERP_CLICK = "serp_clicks_n";
    public static final String RELEVANCE_IN_SAME_REQUEST = "was_rel";
    public static final String WEEKDAY = "weekday";
    public static final String DAYTIME = "daytime";

    public static final String[] LUCENE_FIELDS = {
        "hdr_subject", "pure_body",
        "hdr_from",
        "reply_to",
        "hdr_to",
        "hdr_cc",
        "hdr_bcc",
    };

    private static void add(final FactorGroupFactory factory, boolean inc) {
        MAIL_FACTORS.put(factory.groupName(), factory);

        if (inc) {
            startIndex += factory.size();
        }
    }

    private static void add(final FactorGroupFactory factory) {
        add(factory, true);
    }

    static {
        add(new LogReceivedDateFactorFactory(RECEIVED_DATE, startIndex));
        add(new ClickFactory(TOTAL_CLICKS, "clicks_total_count", startIndex));
        add(new ClickFactory(SERP_CLICKS, "clicks_serp_count", startIndex));
        add(new FidFactorFactory(FID, startIndex));
        add(new AnyEmailInRequestFactory(EMAIL, startIndex));
        add(new RequestSubjectFactory(REQUEST_IN_SUBJECT, startIndex));
        add(new EmailGroupFactory(
                "from_email_group_binary",
                WmiField.FROM,
                new BinaryDisplayInRequestFactory(
                    FROM_NAME_IN_REQUEST,
                    startIndex),
                new BinaryEmailInRequestFactory(
                    FROM_EMAIL_IN_REQUEST,
                    startIndex + 1)),
            false);
        add(new EmailGroupFactory(
            "from_email_group",
            WmiField.FROM,
            new DisplayInRequestFactory(
                FROM_NAME_IN_REQUEST,
                startIndex),
            new EmailInRequestFactory(
                FROM_EMAIL_IN_REQUEST,
                startIndex + 1)));
        add(new EmailGroupFactory(
                "to_email_group_binary",
                WmiField.TO,
                new BinaryDisplayInRequestFactory(TO_NAME_IN_REQUEST, startIndex),
                new BinaryEmailInRequestFactory(TO_EMAIL_IN_REQUEST, startIndex + 1)),
            false);
        add(new EmailGroupFactory(
            "to_email_group",
            WmiField.TO,
            new DisplayInRequestFactory(TO_NAME_IN_REQUEST, startIndex),
            new EmailInRequestFactory(TO_EMAIL_IN_REQUEST, startIndex + 1)));
        add(new MessageTypesFactorFactory(
            new int[] {3, 4, 13, 22},
            Arrays.asList(TYPE_SOCIAL, TYPE_PEOPLE, TYPE_NEWS, TYPE_PERSONAL),
            startIndex));

        add(new DocFieldFactorFactory(LUCENE_SCORE, "#score", startIndex));
        add(
            new DocFieldFactorFactory(
                USER_MTYPE_FREQ,
                MtypeRequestProcessorFactory.MTYPE_FREQUENCY,
                startIndex));

        for (int i = 0; i < LUCENE_FIELDS.length; i++) {
            FactorGroupFactory f
                = new LuceneFieldFactorFactory(LUCENE_FIELDS[i], startIndex);

            add(f);
        }


        add(new PlainReceiveDateFactorFactory(RECEIVED_DATE_PLAIN, startIndex));

        add(
            new NormalizedClickFactory(
                NORMALIZED_TOTAL_CLICK,
                "clicks_total_count",
                startIndex));
        add(
            new NormalizedClickFactory(
                NORMALIZED_SERP_CLICK,
                "clicks_serp_count",
                startIndex));

        add(new DaytimeFactorFactory(DAYTIME, startIndex));
        add(new WeekdayFactorFactory(WEEKDAY, startIndex));
        add(
            new DocFieldFactorFactory(
                RELEVANCE_IN_SAME_REQUEST,
                RequestMidProcessorFactory.WAS_RELEVANT,
                startIndex));

        add(new LuceneFieldFactorFactory("body_text", startIndex));
        add(new LuceneFieldFactorFactory("attachname", startIndex));
        List<FactorGroupFactory> factories =
            new ArrayList<>(MAIL_FACTORS.values());
        factories.sort(Comparator.comparingInt(FactorGroupFactory::startIndex));
    }

    private final boolean rankingEnabled;

    private final boolean topRelevant;
    private final boolean rankEmailRequests;
    private final ImmutableRankingConfig rankingConfig;

    public BasicMailSearchRelevanceFactory(final AsyncHttpServer server)
        throws ConfigException
    {
        super(server, server.config().rankingConfig().mailSearch());

        rankingConfig = server.config().rankingConfig();
        rankEmailRequests = rankingConfig.rankEmailRequests();
        topRelevant = server.config().topRelevant();

        rankingEnabled = sortersFactories.size() > 1;
    }

    public boolean rankingEnabled() {
        return rankingEnabled;
    }

    public boolean topRelevant() {
        return topRelevant;
    }

    public boolean rankEmailRequests() {
        return rankEmailRequests;
    }

    @Override
    protected Map<String, FactorGroupFactory<Document>> factors() {
        return MAIL_FACTORS;
    }

    @Override
    protected MailSearchSorterFactory createDefaultFactory(
        final List<FactorGroupFactory<Document>> factors,
        final List<FactorGroupFactory<Document>> logFactors)
    {
        return new MailSearchDateOrderSorterFactory(this, factors, logFactors);
    }

    @Override
    protected MailSearchSorterFactory createModelFactory(
        final ImmutableRelevanceConfig modelConfig,
        final List<FactorGroupFactory<Document>> factors,
        final List<FactorGroupFactory<Document>> logFactors)
        throws ConfigException
    {
        return new MailSearchModelSorterFactory(
            this,
            (ImmutableMailSearchRelevanceConfig) modelConfig,
            factors,
            logFactors);
    }
}
