package ru.yandex.msearch.proxy.api.async.mail.relevance.search;

import ru.yandex.msearch.proxy.config.ImmutableRelevanceConfig;

import ru.yandex.parser.config.ConfigException;

public class ImmutableMailSearchRelevanceConfig
    extends ImmutableRelevanceConfig
    implements MailSearchRelevanceConfig
{

    private final int rankedPositions;
    private final int minSerpSize;
    private final boolean boosted;

    public ImmutableMailSearchRelevanceConfig(
        final MailSearchRelevanceConfig config)
        throws ConfigException
    {
        super(config);


        rankedPositions = config.rankedPositions();
        minSerpSize = config.minSerpSizeRanking();
        boosted = config.boosted();
    }

    @Override
    public int rankedPositions() {
        return rankedPositions;
    }

    @Override
    public boolean boosted() {
        return boosted;
    }

    @Override
    public int minSerpSizeRanking() {
        return minSerpSize;
    }
}
